IF NOT OBJECT_ID('P_EST_PED_ELTR_AUDITORIA') IS NULL
	BEGIN
			DROP PROCEDURE P_EST_PED_ELTR_AUDITORIA
	END
go
--EXEC P_EST_PED_ELTR_AUDITORIA 1, 0,'2018-03-14','2018-03-14'
CREATE PROCEDURE P_EST_PED_ELTR_AUDITORIA  @CD_EMP INT =1, 
										   @CD_GRP_PED INT=0,
										   @DT_INI DATETIME=NULL, 
										   @DT_FIM DATETIME=NULL AS 
SET NOCOUNT ON 
SET ANSI_WARNINGS OFF; 
CREATE TABLE #RsPedEltr 
		(CD_EMP INT,
		CD_FILIAL INT,  
		NM_FANT VARCHAR(200),  
		CD_PED_SOL INT,  
		DT_PED DATETIME,  
		HORA_DEMANDA DATETIME,
		CD_FIL_ENTR INT,
		CD_GRP_PED INT)


CREATE TABLE #RsAnalise 
		(CD_EMP INT,
		CD_FILIAL INT,  
		NM_FANT VARCHAR(200),  
		CD_PED_SOL INT,  
		DT_PED DATETIME,  
		HORA_DEMANDA DATETIME,  
		CD_ARV_MERC_LINHA INT,  
		CD_PROD INT,  
		CD_FORN INT,  
		RZ_FORN VARCHAR(200),  
		ORD_ENV INT,  
		QTDE_DEMANDA MONEY,  
		QTDE_DEMANDA_FORN MONEY,  
		QTDE_ATENDIDO MONEY,  
		QTDE_NAO_ATENDIDO MONEY,  
		VLR_ATENDIDO MONEY,  
		VLR_DEMANDA MONEY,  
		CD_FABRIC INT,  
		NM_FABRIC VARCHAR(200),  
		DS_PROD VARCHAR(200),  
		CD_PED INT,  
		COMPRA_POR_SUPRIMENTO VARCHAR(60), 
		CD_PED_FORN INT,  
		QTDE_REG_DEM MONEY, 
		CD_PROD_FORN INT,  
		ST_COMPRA_FORN VARCHAR(50),  
		EMB_ENT_FORN VARCHAR(15),  
		SIT_ATENDIDO VARCHAR(15), 
		CD_MSG_FORN VARCHAR(10), 
		DS_MSG_FORN VARCHAR(100), 
		CD_CTR_ENV INT, 
		ORDMELHORCOND INT, 
		ST_ENVIADO VARCHAR(5), 
	    FLAG_COMPRA_PHARMALINK VARCHAR(50),
		CD_GRP_PED INT,
		VLR_PROD MONEY,
		DS_ARV_MERC_LINHA VARCHAR(150))

IF @CD_GRP_PED > 0 
BEGIN
INSERT INTO #RsPedEltr
	SELECT 
		PRC_FILIAL.CD_EMP,  
		PRC_FILIAL.CD_FILIAL,  
		PRC_FILIAL.NM_FANT,  
		EST_PED_ELTR.CD_PED_SOL,  
		EST_PED_ELTR.DT_PED,  
		EST_PED_ELTR.HORA_DEMANDA AS DT_DEMANDA,
		EST_PED_ELTR.CD_FIL_ENTR,
		GRP_PED.CD_GRP_PED
	FROM	
		EST_PED_ELTR  INNER JOIN EST_PED_ELTR_IT ON        
		EST_PED_ELTR.CD_EMP = EST_PED_ELTR_IT.CD_EMP        AND 
		EST_PED_ELTR.CD_PED_SOL = EST_PED_ELTR_IT.CD_PED_SOL  
		INNER JOIN PRC_FILIAL ON        
		PRC_FILIAL.CD_EMP = EST_PED_ELTR.CD_EMP        AND 
		PRC_FILIAL.CD_FILIAL = EST_PED_ELTR.CD_FIL_ENTR  
		INNER JOIN EST_PED_ELTR_GRP_PED_EST_PED_ELTR GRP_PED ON        
		EST_PED_ELTR.CD_EMP = GRP_PED.CD_EMP        AND 
		EST_PED_ELTR.CD_PED_SOL = GRP_PED.CD_PED_SOL  
	WHERE 
		GRP_PED.CD_EMP = @CD_EMP
		AND GRP_PED.CD_GRP_PED = @CD_GRP_PED
	GROUP BY 
		PRC_FILIAL.CD_EMP,  
		PRC_FILIAL.CD_FILIAL, 
		PRC_FILIAL.NM_FANT, 
		EST_PED_ELTR.CD_PED_SOL, 
		EST_PED_ELTR.DT_PED, 
		EST_PED_ELTR.HORA_DEMANDA,
		EST_PED_ELTR.CD_FIL_ENTR,
				GRP_PED.CD_GRP_PED
END

IF @CD_GRP_PED = 0 
BEGIN
INSERT INTO #RsPedEltr
	SELECT 
		PRC_FILIAL.CD_EMP,  
		PRC_FILIAL.CD_FILIAL,  
		PRC_FILIAL.NM_FANT,  
		EST_PED_ELTR.CD_PED_SOL,  
		EST_PED_ELTR.DT_PED,  
		EST_PED_ELTR.HORA_DEMANDA AS DT_DEMANDA,
		EST_PED_ELTR.CD_FIL_ENTR,
		0
	FROM	
		EST_PED_ELTR  INNER JOIN EST_PED_ELTR_IT ON        
		EST_PED_ELTR.CD_EMP = EST_PED_ELTR_IT.CD_EMP        AND 
		EST_PED_ELTR.CD_PED_SOL = EST_PED_ELTR_IT.CD_PED_SOL  
		INNER JOIN PRC_FILIAL ON        
		PRC_FILIAL.CD_EMP = EST_PED_ELTR.CD_EMP        AND 
		PRC_FILIAL.CD_FILIAL = EST_PED_ELTR.CD_FIL_ENTR  
	WHERE 
		EST_PED_ELTR.CD_EMP = @CD_EMP
		AND EST_PED_ELTR.DT_PED  BETWEEN @DT_INI AND @DT_FIM
	GROUP BY 
		PRC_FILIAL.CD_EMP,  
		PRC_FILIAL.CD_FILIAL, 
		PRC_FILIAL.NM_FANT, 
		EST_PED_ELTR.CD_PED_SOL, 
		EST_PED_ELTR.DT_PED, 
		EST_PED_ELTR.HORA_DEMANDA,
		EST_PED_ELTR.CD_FIL_ENTR
END

INSERT INTO #RsAnalise
Select 
	PRC_FILIAL.CD_EMP,  
	PRC_FILIAL.CD_FILIAL,  
	PRC_FILIAL.NM_FANT,  
	EL.CD_PED_SOL,  
	EL.DT_PED,  
	EL.HORA_DEMANDA AS DT_DEMANDA,  
	EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA AS LINHA,  
	EST_PROD.CD_PROD,  
	ISNULL(EST_PED_ELTR_FORN.CD_FORN, 0) AS CD_FORN,  
	'NAO ENVIADO A FORNECEDOR' AS RZ_FORN,  
	ISNULL(EST_PED_ELTR_FORN.ORD_ENV, 0) AS ORD_ENV,  
	EST_PED_ELTR_IT.QT_IT AS QTDE_DEMANDA,  
	0 AS QTDE_DEMANDA_FORN,  
	0 AS QTDE_ATENDIDO,  
	0 AS QTDE_NAO_ATENDIDO,  
	0 AS VLR_ATENDIDO,  
	0 AS VLR_DEMANDA,  
	EST_PROD_FABRIC.CD_FABRIC,  
	EST_PROD_FABRIC.NM_FABRIC,  
	EST_PROD.DS_PROD,  
	0 AS CD_PED,  
	CASE WHEN COMPRA_POR_SUPRIMENTO = 0 THEN      'RESSUPRIMENTO'  WHEN 
		COMPRA_POR_SUPRIMENTO = 1 
	THEN      
		'SUPRIMENTO' 
	WHEN COMPRA_POR_SUPRIMENTO = 2 THEN      
		'SUP-RESSUP' 
	END AS COMPRA_POR_SUPRIMENTO, 
	0 AS CD_PED_FORN,  
	0 AS QTDE_REG_DEM, 
	'' AS CD_PROD_FORN,  
	'' AS ST_COMPRA_FORN,  
	'' AS EMB_ENT_FORN, 
	'NAO ATENDIDO' AS SIT_ATENDIDO, 
	'0000'   AS CD_MSG_FORN, 
	'NAO INFORMADO' AS DS_MSG_FORN, 
	0 AS CD_CTR_ENV, 
	0 AS ORDMELHORCOND, 
	'NAO' AS ST_ENVIADO, 
	CASE WHEN FLAG_COMPRA_PHARMALINK=0 THEN     
		'0 - SEM PROCESSO DE VAN DE COMPRAS' 
	WHEN FLAG_COMPRA_PHARMALINK=1 THEN     
		'1 - PHARMALINK'
	 WHEN FLAG_COMPRA_PHARMALINK=2 THEN     
		'2 - ENTIRE' 
	WHEN FLAG_COMPRA_PHARMALINK=3 THEN     
		'3 - PHARMALINK E ENTIRE' 
	WHEN FLAG_COMPRA_PHARMALINK=4 THEN     
		'4 - OL MIX' 
	WHEN FLAG_COMPRA_PHARMALINK=5 THEN     
		'5 - FIDELIZE' 
	WHEN FLAG_COMPRA_PHARMALINK=6 THEN     
		'6 - WEBOL' 
	ELSE      
		'NAO DEFINIDO' 
	END As FLAG_COMPRA_PHARMALINK,
	EL.CD_GRP_PED,
	EST_PED_ELTR_IT.VLR_PROD,
	EST_ARV_MERC_LINHA.DS_ARV_MERC_LINHA
From	
	#RsPedEltr EL  INNER JOIN EST_PED_ELTR_IT ON        
	EL.CD_EMP = EST_PED_ELTR_IT.CD_EMP        AND 
	EL.CD_PED_SOL = EST_PED_ELTR_IT.CD_PED_SOL  
	INNER JOIN PRC_FILIAL ON        
	PRC_FILIAL.CD_EMP = EL.CD_EMP        AND 
	PRC_FILIAL.CD_FILIAL = EL.CD_FIL_ENTR  
	INNER JOIN EST_PROD ON        
	EST_PROD.CD_EMP = EST_PED_ELTR_IT.CD_EMP        AND 
	EST_PROD.CD_PROD = EST_PED_ELTR_IT.CD_PROD  
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON        
	EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP        AND 
	EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD  
	INNER JOIN EST_ARV_MERC_LINHA ON        
	EST_ARV_MERC_LINHA.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP        AND 
	EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA  
	INNER JOIN EST_PROD_FABRIC ON        
	EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC  
	INNER JOIN EST_PED_ELTR_GRP_PED_EST_PED_ELTR GRP_PED ON        
	EL.CD_EMP = GRP_PED.CD_EMP        AND 
	EL.CD_PED_SOL = GRP_PED.CD_PED_SOL
	LEFT JOIN EST_PED_ELTR_FORN ON 
	EST_PED_ELTR_FORN.CD_EMP = EL.CD_EMP AND
	EST_PED_ELTR_FORN.CD_PED_SOL = EL.CD_PED_SOL
GROUP BY 
	PRC_FILIAL.CD_EMP,  
	PRC_FILIAL.CD_FILIAL, 
	PRC_FILIAL.NM_FANT, 
	EL.CD_PED_SOL, 
	EL.DT_PED, 
	EL.HORA_DEMANDA, 
	EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA, 
	EST_PROD.CD_PROD, 
	EST_PROD_FABRIC.CD_FABRIC, 
	EST_PROD_FABRIC.NM_FABRIC, 
	EST_PROD.DS_PROD, 
	COMPRA_POR_SUPRIMENTO, 
	EST_PED_ELTR_IT.QT_IT, 
	EST_PED_ELTR_IT.QT_IT, 
	EST_PED_ELTR_IT.VLR_PROD, 
	FLAG_COMPRA_PHARMALINK,
	EL.CD_GRP_PED,
	EST_PED_ELTR_IT.VLR_PROD,
	EST_ARV_MERC_LINHA.DS_ARV_MERC_LINHA,
	EST_PED_ELTR_FORN.ORD_ENV,
	EST_PED_ELTR_FORN.CD_FORN

--Buscando o grupo de demanda
UPDATE
	a
SET 
	a.CD_GRP_PED  = GRP_PED.CD_GRP_PED 
FROM
	#RsAnalise a INNER JOIN EST_PED_ELTR_GRP_PED_EST_PED_ELTR GRP_PED ON        
	A.CD_EMP = GRP_PED.CD_EMP        AND 
	A.CD_PED_SOL = GRP_PED.CD_PED_SOL  
WHERE
	A.CD_GRP_PED = 0 

--Buscando envio para fornecedor
UPDATE
	A
SET 
	A.RZ_FORN = PG_FORN.RZ_FORN,
	A.ORDMELHORCOND = E.ORDMELHORCOND,
	A.CD_CTR_ENV =  E.CD_CTR_ENV
FROM
	#RsAnalise a
	INNER JOIN PG_FORN ON        
	PG_FORN.CD_EMP = a.CD_EMP        AND 
	PG_FORN.CD_FORN = a.CD_FORN  
	INNER JOIN EST_PED_ELTR_FORN_CTR_ENV  E ON        
	a.CD_EMP = E.CD_EMP        AND 
	a.CD_PED_SOL = E.CD_PED_SOL        AND 
	a.CD_FORN = E.CD_FORN        AND 
	a.ORD_ENV = E.ORD_ENV  

--Buscando mensagem de nao atendimento
UPDATE
	a
SET 
	a.CD_MSG_FORN = R.CD_MSG_FORN, 
	a.DS_MSG_FORN =  R.DS_MSG_FORN 
FROM
	#RsAnalise a INNER JOIN EST_PED_ELTR_FORN_FALTAS  F ON  
	A.CD_EMP     = F.CD_EMP     AND   
	A.CD_FORN    = F.CD_FORN AND 
	A.CD_PED_SOL = F.CD_PED_SOL AND 
	A.CD_PROD    = F.CD_PROD AND 
	A.ORD_ENV    = F.ORD_ENV  
	INNER JOIN PG_FORN_MSG_RET R ON  
	F.CD_EMP      = R.CD_EMP      AND 
	F.CD_FORN     = R.CD_FORN AND 
	F.CD_MSG_FORN = R.CD_MSG_FORN  

--Buscando codigo do produto no fornecedor
UPDATE
	a
SET 
	a.CD_PROD_FORN  = F.CD_PROD_FORN,
	a.EMB_ENT_FORN = (CAST(f.APRES_EMB_CP AS VARCHAR) + ' X ' + CAST(ROUND(f.APRES_QT_CP,0) AS VARCHAR)),
	a.ST_COMPRA_FORN = (CASE WHEN f.COMPRA_INATIVA = 1 THEN 
							'COMPRA INATIVA' 
						ELSE 
							'COMPRA LIBERADA' 
						END) 
FROM
	#RsAnalise a INNER JOIN EST_PROD_FORN  F ON  
	A.CD_EMP     = F.CD_EMP     AND   
	A.CD_PROD    = F.CD_PROD AND
	A.CD_FORN    = F.CD_FORN 

--Buscando os itens enviado para o fornecedor
UPDATE
	a
SET 
	a.QTDE_DEMANDA_FORN=EST_PED_ELTR_FORN_IT.QT_IT_ENV,  
	a.VLR_DEMANDA=(EST_PED_ELTR_FORN_IT.QT_IT_ENV * A.VLR_PROD),
	A.ST_ENVIADO='SIM',
	A.QTDE_NAO_ATENDIDO = EST_PED_ELTR_FORN_IT.QT_IT_ENV
FROM
	#RsAnalise a INNER JOIN EST_PED_ELTR_FORN_IT ON        
	A.CD_EMP = EST_PED_ELTR_FORN_IT.CD_EMP AND 
	A.CD_PED_SOL = EST_PED_ELTR_FORN_IT.CD_PED_SOL AND 
	A.CD_FORN = EST_PED_ELTR_FORN_IT.CD_FORN AND 
	A.ORD_ENV = EST_PED_ELTR_FORN_IT.ORD_ENV AND 
	A.CD_PROD = EST_PED_ELTR_FORN_IT.CD_PROD;

--Buscando a quantidade retornada pelo fornecedor
WITH TblRetorno
AS
(
SELECT
	A.CD_EMP,
	A.CD_PED_SOL,
	A.CD_FORN,
	A.ORD_ENV,
	EST_PED_CP_IT.QT_IT AS QTDE_ATENDIDO,  
	(A.QTDE_DEMANDA_FORN - EST_PED_CP_IT.QT_IT) AS QTDE_NAO_ATENDIDO,  
	(EST_PED_CP_IT.QT_IT  * EST_PED_CP_IT.VLR_IT) AS VLR_ATENDIDO,
	CASE WHEN (A.QTDE_DEMANDA_FORN - EST_PED_CP_IT.QT_IT) > 0 THEN 
		'ATENDIDO PARCIAL'        
	ELSE 
		'ATENDIDO TOTAL' 
	END AS SIT_ATENDIDO, 
	EST_PED_CP.CD_PED_FORN AS CD_PED_FORN,
	EST_PED_ELTR_FORN_PED_CP.CD_PED,
	A.CD_PROD,
	ISNULL(R.CD_MSG_FORN, '0000') AS CD_MSG_FORN,
	ISNULL(R.DS_MSG_FORN, 'NAO INFORMADO') AS DS_MSG_FORN
FROM
	#RsAnalise a INNER JOIN EST_PED_ELTR_FORN_PED_CP ON        
	A.CD_EMP = EST_PED_ELTR_FORN_PED_CP.CD_EMP AND 
	A.CD_PED_SOL = EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL AND 
	A.CD_FORN = EST_PED_ELTR_FORN_PED_CP.CD_FORN AND 
	A.ORD_ENV = EST_PED_ELTR_FORN_PED_CP.ORD_ENV  
	INNER JOIN EST_PED_CP_IT ON        
	EST_PED_CP_IT.CD_EMP  = A.CD_EMP AND 
	EST_PED_CP_IT.CD_PED  = EST_PED_ELTR_FORN_PED_CP.CD_PED AND 
	EST_PED_CP_IT.CD_FILIAL = EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR AND 
	EST_PED_CP_IT.CD_PROD = A.CD_PROD  
	INNER JOIN EST_PED_CP ON        
	EST_PED_CP.CD_EMP  = EST_PED_CP_IT.CD_EMP AND 
	EST_PED_CP.CD_PED  = EST_PED_CP_IT.CD_PED AND 
	EST_PED_CP.CD_FILIAL = EST_PED_CP_IT.CD_FILIAL
	LEFT JOIN PG_FORN_MSG_RET R ON  
	EST_PED_CP_IT.CD_EMP      = R.CD_EMP      AND 
	EST_PED_CP.CD_FORN     = R.CD_FORN AND 
	EST_PED_CP_IT.CD_MSG_FORN = R.CD_MSG_FORN 
)

UPDATE
	a
SET 
	a.QTDE_ATENDIDO=TblRetorno.QTDE_ATENDIDO,  
	a.QTDE_NAO_ATENDIDO=TblRetorno.QTDE_NAO_ATENDIDO,  
	A.VLR_ATENDIDO=TblRetorno.VLR_ATENDIDO,
	a.SIT_ATENDIDO=TblRetorno.SIT_ATENDIDO, 
	a.CD_PED_FORN =TblRetorno.CD_PED_FORN,
	a.CD_PED =TblRetorno.CD_PED,
	a.CD_MSG_FORN = TblRetorno.CD_MSG_FORN,
	a.DS_MSG_FORN = TblRetorno.DS_MSG_FORN
FROM
	#RsAnalise a INNER JOIN TblRetorno ON        
	A.CD_EMP = TblRetorno.CD_EMP AND 
	A.CD_PED_SOL = TblRetorno.CD_PED_SOL AND 
	A.CD_FORN = TblRetorno.CD_FORN AND 
	A.ORD_ENV = TblRetorno.ORD_ENV AND
	A.CD_PROD = TblRetorno.CD_PROD   

SELECT * FROM #RsAnalise
DROP TABLE #RsPedEltr
DROP TABLE #RsAnalise